﻿#NoEnv
#SingleInstance IGNORE

if(A_OSVersion!="WIN_XP" and !A_IsAdmin){
	Run *RunAs "%A_ScriptFullPath%"  ; Requires v1.0.92.01+
	ExitApp
}

CoordMode,Mouse,Relative
CoordMode,ToolTip,Relative ; Screen

SetTitleMatchMode, 2
SetBatchLines, -1
SetControlDelay, -1
ListLines, Off
OnExit, GuiClose

ComObjError(false)
PptApp:=ComObjActive("{91493441-5A91-11CF-8700-00AA0060263B}")
If !PptApp
	PptApp:=ComObjCreate("{91493441-5A91-11CF-8700-00AA0060263B}")
if !PptApp {
	Msgbox,16, Error, PowerPoint 를 실행할 수 없습니다.`r`n`r`nPowerPoint 를 종료한 후에 실행하거나 설치한 후에 실행해 주세요.
	ExitApp
}

PsApp:=ComObjActive("Photoshop.Application")
if !PsApp
	PsApp:=ComObjCreate("Photoshop.Application")
if !PsApp {
	Msgbox,16, Error, PhotoShop 을 실행할 수 없습니다.`r`n`r`PhotoShop 을 종료한 후에 실행하거나 설치한 후에 실행해 주세요.
	PptApp.Quit
	ExitApp
}

if(A_OSVersion="WIN_XP"){
	clef:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAACkAAAAiCAIAAABNxWdiAAAA5UlEQVR42s3WSwLCIAwE0M79D12ti6qQzwyhtGwN89JgRWz3LTzU3vc92Qy2dTMKUvWAGgSCrCvCZrJsV+AmHMFnV8C/hGDPgl27+NDv7WSLR2Xxob+H9ylotsd9lOy/L61lxx3Ay5Lg2PYSBm3jhyK0zZAROy7jH2Cd3efIdho9aC9ej7GZcTFXHDl2NL+CleO83C7219rTR6rZa/j2HVPttJK0j7Pu7yKJ3+hLpd8C78ZN+bN+mj3AM2M35wTmYIq2l4bi/ZHawRTBvFFqE8x/jdyWstR2KdvrIF3JUNW4ietO+wUnbg4CIckZiAAAAABJRU5ErkJggg==")
	mark:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAAA0AAAAUCAIAAADZUCB4AAAAWElEQVR42r3SwQ4AEAwDUP3/j56IhI2m5oCb7EksLcysJA68A+BnYdQvi9jpwQ3anEAXrtMXTu8R3HFl0Dz8m7nvR7fmRh3pgUbEUVRo//hPfB6i20j2vgKySnHZ3KE25AAAAABJRU5ErkJggg==")
	hung:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAADgAAAA9CAIAAAB3KT36AAABKUlEQVR42u3ZSQ7DIAwF0HL/Q1NlU6kpYGN/D6T2OoKXAeL8tN7764RqEGhrbX2AfpaCmkLJ+fzrwytoQQv619BZOZwAySCgztd4gZlCAx+DIWkMDX9Yf1UDqEYJXJo32B26Nfpuq6EZXAIFtEI88df92YWivgh2r8hzoRCrx60XiwWbAAxqWsSqz2OloRmsrDdTLHfae9D9lReX6OP4K9dIzATIAwixWzYjJilxqAsavsbJupAFLWjmKqgRdH2Qz2lok5KCQqH+z+5J2dNePxq7D3BDsgy7Ff0pkkE5tGqhdh8IKyh/LE27LZtlG5oie3JLyATTPRQKtHrEjhqxeHzYPgp/FZ+R5nFDsjPe9bFWYZrnyQWkedZclsH6h4HSJ4Rq6NqJTokd39YrkZasgN6WAAAAAElFTkSuQmCC")
}else{
	clef:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAACoAAAAiCAIAAACm8txhAAABkElEQVR42sWWwUHEIBBFQy9uEdqBFoJXLcAa1qsWEjtYS/Cw9oLEJGSAP59J9gC3hRnenw/ZwQ1dh+uMH/3w9IlW7s/Xy8sdSf19fzi9flsgfgwfjxjvhwHROdxObmjA5lP417PDfh2QgPAMfgMbbQ7w+kkd8Zx7UOH10m8uHAhw2sKBymflNpULx8FZO3xOWJZL55iSOdaBOStdaF0CkHpVwxSc4XfQlUIV97CEGOyK39D6KrsOVOzn/vlR4q3FQ5XEfmLhfrwWxe3HArwFn5nfsnfX/7Xv3XA742W/143bjq19tnb749UL1/N2Icjea56hHZo7ZvzwQgjiRhJ+ymxrNH59UeaEl7Mm51p9ydY1p6gZL+eZAU0FDfsl/X+HFS8caL0xUyBpMOyPMZUeIRveeL2rnfJYYr8oPS1LvAxpPrMT7Octk6rZL+DysZXjB/st0AayX5hVPDUrPLPWMtbklKmyNXyRZDwJaP/mJdxExRcHsUMFaOyqhxwPNPD9KnRDsgFPVPBhcKt3w+2L/wPyst1rbGTqowAAAABJRU5ErkJggg==")
	mark:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAAA0AAAAUCAIAAADZUCB4AAAAlUlEQVR42o3SQRWAIAwGYOmiNxNoAg2iR42iRw2CCbQEdkGeyBgwQK58bxv8Y1LK4sdh1t1rW80X3Axcbp3vjpH1e1ilWcQ5lcZ5hUipnEgw6K8cp3u6MF9Pt87Nh13wJVFXpKiZL8zD+U14L5Ebgl8stIMhIJB0PZtxaj68CYTTyq4A6TRyd8p3MYPc+8CaFNH5yPMA846abTG4gREAAAAASUVORK5CYII=")
	hung:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAADYAAAA7CAIAAAC/ue5UAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAGESURBVHja7FnRFcIgDDycxS7hBi7Sfuoo/rqITmAn6FftLvilVh8FkgBGJQOEK7nk0gNWGNfDBr5oT9ITVlAfXwAR9+s8tbpwPQlSC10hVog/OXQWIv8sCsoPuMKWODaHKwViYXQhnChfWWrdkfD+Htllad7vEkyA5B2LkvwVJIhJPLROCPXlFBBYKIYXD3N+1I+pS79vjOnOsgPPnTHNvuepC7EPSWWX5IaGkR3d0VpA+uaiBnlx0Acadgg/uZGO41nWnADE3FgjZwIY4sBnK8s9MdZa7fKiZhgukqH+AVaIFeL/uBFlJlJgoNdC5y102b2R6Ol8bKt1kxJqPKdIT0fF04b330XL24vM02H9SdPJMy83yHlk746MU0CpsvxVNBrnrEIryuUft2m4tt5dCLQnQBzGKVlDTOPAUJcYlqRxGGNu0MlFQt9xORlfXXdH8+fiMmKmVPmcMRXW2PsXw+oSaUdFFDljS4SBAmMs0IDIaDIl0nmUMMRkAxb5NwKpuN8GADy9vz1k+DM2AAAAAElFTkSuQmCC")
}
bar:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAAAQAAABECAIAAAApywNFAAAAKElEQVR42mP8//8/AwwwMiABVA5QGSMjSAjEGDKcUf8Mbs6I8g+cAwAInVWm8TcS1gAAAABJRU5ErkJggg==")
line:=Create_IMG("iVBORw0KGgoAAAANSUhEUgAAAAIAAAFKCAIAAAC4qBnGAAAAJ0lEQVR42mP8//8/AwMD4yg1SuGnGMAARo3aN2rfKDVKjVKj1NCnAHn2vbj4+A3JAAAAAElFTkSuQmCC")

EnvGet, WorkFolder, UserProFile
WorkFolder:=WorkFolder (A_OSVersion="WIN_XP"?"\바탕 화면\":"\Desktop\") ; 결과물 저장위치 --> 바탕화면
IfNotExist, C:\Users\Public\
	FileCreateDir, C:\Users\Public

PTVer:=SubStr(PptApp.Version,1,2), FHD:=A_ScreenWidth<1919?0:1, PptApp.Visible:=True

Gosub, InitPS
Gosub, InitNWC

Gui, 3: New, LabelShowMain
Gui, 3: Add, Text, ym+8 Section, 제목:
Gui, 3: Add, Text, Section, 작사:
Gui, 3: Add, Text, , 작곡:
Gui, 3: Add, Text, , 파일:

Gui, 3: Add, Edit, xs+31 ym+4 w204 r1 -Wrap -VScroll vNwcTitle
Gui, 3: Add, Edit, w161 r1 -Wrap -VScroll vNwcWord
Gui, 3: Add, Edit, w161 r1 -Wrap -VScroll vNwcMusic
Gui, 3: Add, Edit, w370 r1 -VScroll vNwcFile

Gui, 3: Add, Text, xs+209 ys, 가사:
Gui, 3: Add, Text, , 악보:
Gui, 3: Add, Edit, xs+240 ys-4 w161 r1 -Wrap -VScroll ReadOnly vNwclyric
Gui, 3: Add, Edit, w161 r1 -Wrap -VScroll ReadOnly vNwcScore

Gui, 3: Add, Text, xm+246 ym+8 Section, ＃
Gui, 3: Add, Edit, xm+258 ym+4 w20 r1 -Wrap -VScroll vNwcMajor1
Gui, 3: Add, Text, xm+287 ys, ♭
Gui, 3: Add, Edit, xm+299 ym+4 w20 r1 -Wrap -VScroll vNwcMajor2
Gui, 3: Add, Text, xm+330 ys, 박자:
Gui, 3: Add, Edit, xm+361 ym+4 w40 r1 -Wrap -VScroll vNwcTempo
Gui, 3: Add, Edit, xm ym+113 w401 r14 vDiclyric

Gui, 3: Add, Button, xm+407 ym+3 w85 gInitlyric, 초  기  화
Gui, 3: Add, Button, w85 gNwcFile, 파일 이름
Gui, 3: Add, Button, w85 gNwcNew, NWC 생성
Gui, 3: Add, Button, w85 gPsTitle, PSD 제목
Gui, 3: Add, Button, w85 gLyricAp, NWC 가사
Gui, 3: Add, Button, w85 gWidthAp, NWC 간격
Gui, 3: Add, Button, w85 gPPTMake, PPT 생성
Gui, 3: Add, Button, w85 gPPTLyric, PPT 가사
Gui, 3: Add, Button, w85 gPPTHyper, PPT 링크
Gui, 3: Add, Button, w85 gPPTWide, PPT 넓게
Gui, 3: Add, Button, w85 gPPTSave, PPT 저장

Gui, 3: Show, , PPT악보 도우미
WinMove, PPT악보 도우미, , A_ScreenWidth-GetWinPos(), 0
OnMessage(0x202, "WM_LBUTTONUP")
if !FileExist(A_ScriptDir "\PPT_Frm.2.75.nwc") {
	MsgBox, PPT_Frm.2.75.nwc 파일이 없습니다.`r`n`r`n확인 후 다시 실행해 주세요.
	PptApp.Quit
	ExitApp
}
return

GuiClose:
;	PptApp.Quit
ShowMainClose:
	ExitApp

+F11::
	ListVars
return
+F12::
	Reload
return
; ----------------------------------------------------------------------------------------------------------------------


; ----------------------------------------------------------------------------------------------------------------------
; https://github.com/tariqporter/Gdip/blob/master/Gdip.ahk
CaptureToFile(Ny, x, w, h, hung, sFile=""){
	WinGetPos, ax, ay, , , A
	ImageSearch, xpos, ypos, x, Ny+130, x+w, Ny+234, *100 HBITMAP:*%hung%
	If !ErrorLevel{
		Hung:=1, xp:=A_OSVersion="WIN_XP"?1:0
		Gui, 1: New
		Gui, 1: -Caption +Toolwindow
		Gui, 1: Color, FFFFFF
		Gui, 1: Show, % "w14 h1 x" xpos+ax+xp+20 " y" ypos+ay+xp+36
	}
	pToken:=Gdip_Startup()
	pBitmap:=Gdip_BitmapFromScreen(ax+x, ay+Ny-119, w, h)
	if sFile
		Gdip_SaveBitmapToFile(pBitmap, sFile)
	DllCall("Gdiplus\GdipDisposeImage", "uint", pBitmap)
	Gdip_Shutdown(pToken)
	if Hung
		Gui, 1: Destroy
}
CreateDIBSection(w, h, hdc, bpp=32, ByRef ppvBits=0){
	VarSetCapacity(bi, 40, 0)
	NumPut(w, bi, 4), NumPut(h, bi, 8), NumPut(40, bi, 0), NumPut(1, bi, 12, "ushort"), NumPut(0, bi, 16), NumPut(bpp, bi, 14, "ushort")
	hbm:=DllCall("CreateDIBSection", "uint" , hdc, "uint" , &bi, "uint" , 0, "uint*", ppvBits, "uint" , 0, "uint" , 0)
	return, hbm
}
Gdip_Startup(){
	if !DllCall("GetModuleHandle", "str", "gdiplus")
		DllCall("LoadLibrary", "str", "gdiplus")
	VarSetCapacity(si, 16, 0), si:=Chr(1)
	DllCall("Gdiplus\GdiplusStartup", "uint*", pToken, "uint", &si, "uint", 0)
	return pToken
}
Gdip_Shutdown(pToken){
	DllCall("Gdiplus\GdiplusShutdown", "uint", pToken)
	if hModule:=DllCall("GetModuleHandle", "str", "gdiplus")
		DllCall("FreeLibrary", "uint", hModule)
	return 0
}
Gdip_BitmapFromScreen(x, y, w, h){
	chdc:=DllCall("CreateCompatibleDC", "Uint", 0)
	hbm:=CreateDIBSection(w, h, chdc)
	obm:=DllCall("SelectObject", "uint", chdc, "uint", hbm)
	hhdc:=DllCall("GetDC", "uint", 0)
	DllCall("gdi32\BitBlt", "uint", chdc, "int", 0, "int", 0, "int", w, "int", h, "uint", hhdc, "int", x, "int", y, "uint", 0x00CC0020)
	DllCall("ReleaseDC", "uint", 0, "uint", hhdc)
	DllCall("Gdiplus\GdipCreateBitmapFromHBITMAP", "uint", hbm, "uint", 0, "uint*", pBitmap)
	DllCall("SelectObject", "uint", chdc, "uint", obm),
	DllCall("DeleteObject", "uint", hbm)
	DllCall("DeleteDC", "uint", hhdc)
	DllCall("DeleteDC", "uint", chdc)
	return, pBitmap
}
Gdip_SaveBitmapToFile(pBitmap, sOutput){
	SplitPath, sOutput,,, Extension
	if Extension not in BMP,DIB,RLE,JPG,JPEG,JPE,JFIF,GIF,TIF,TIFF,PNG
		return -1
	Extension:="." Extension
	DllCall("Gdiplus\GdipGetImageEncodersSize", "uint*", nCount, "uint*", nSize)
	VarSetCapacity(ci, nSize)
	DllCall("Gdiplus\GdipGetImageEncoders", "uint", nCount, "uint", nSize, "uint", &ci)
	if !(nCount&&nSize)
		return -2
	Loop, %nCount%
	{
		Location:=NumGet(ci, 76*(A_Index-1)+44)
		if !A_IsUnicode {
			nSize:=DllCall("WideCharToMultiByte", "uint", 0, "uint", 0, "uint", Location, "int", -1, "uint", 0, "int",  0, "uint", 0, "uint", 0)
			VarSetCapacity(sString, nSize)
			DllCall("WideCharToMultiByte", "uint", 0, "uint", 0, "uint", Location, "int", -1, "str", sString, "int", nSize, "uint", 0, "uint", 0)
			if !InStr(sString, "*" Extension)
				continue
		}else{
			nSize:=DllCall("WideCharToMultiByte", "uint", 0, "uint", 0, "uint", Location, "int", -1, "uint", 0, "int",  0, "uint", 0, "uint", 0)
			sString:=""
			Loop, %nSize%
				sString.=Chr(NumGet(Location+0, 2*(A_Index-1), "char"))
			if !InStr(sString, "*" Extension)
				continue
		}
		pCodec:=&ci+76*(A_Index-1)
		break
	}
	if !pCodec
		return -3
	if !A_IsUnicode {
		nSize:=DllCall("MultiByteToWideChar", "uint", 0, "uint", 0, "uint", &sOutput, "int", -1, "uint", 0, "int", 0)
		VarSetCapacity(wOutput, nSize*2)
		DllCall("MultiByteToWideChar", "uint", 0, "uint", 0, "uint", &sOutput, "int", -1, "uint", &wOutput, "int", nSize)
		VarSetCapacity(wOutput, -1)
		if !VarSetCapacity(wOutput)
			return -4
		E:=DllCall("Gdiplus\GdipSaveImageToFile", "uint", pBitmap, "uint", &wOutput, "uint", pCodec, "uint", 0)
	}else E:=DllCall("Gdiplus\GdipSaveImageToFile", "uint", pBitmap, "uint", &sOutput, "uint", pCodec, "uint", 0)
	return E?-5:0
}
; ----------------------------------------------------------------------------------------------------------------------
Create_IMG(img64, From=""){
	VarSetCapacity(B64, StrLen(img64) << !!A_IsUnicode)
	B64:=img64
	If !DllCall("Crypt32.dll\CryptStringToBinary", "Ptr", &B64, "UInt", 0, "UInt", 0x01, "Ptr", 0, "UIntP", DecLen, "Ptr", 0, "Ptr", 0)
		Return False
	VarSetCapacity(Dec, DecLen, 0)
	If !DllCall("Crypt32.dll\CryptStringToBinary", "Ptr", &B64, "UInt", 0, "UInt", 0x01, "Ptr", &Dec, "UIntP", DecLen, "Ptr", 0, "Ptr", 0)
		Return False
	; Bitmap creation adopted from "How to convert Image data (JPEG/PNG/GIF) to hBITMAP?" by SKAN
	; -> http://www.autohotkey.com/board/topic/21213-how-to-convert-image-data-jpegpnggif-to-hbitmap/?p=139257
	hData:=DllCall("Kernel32.dll\GlobalAlloc", "UInt", 2, "UPtr", DecLen, "UPtr")
	pData:=DllCall("Kernel32.dll\GlobalLock", "Ptr", hData, "UPtr")
	DllCall("Kernel32.dll\RtlMoveMemory", "Ptr", pData, "Ptr", &Dec, "UPtr", DecLen)
	DllCall("Kernel32.dll\GlobalUnlock", "Ptr", hData)
	DllCall("Ole32.dll\CreateStreamOnHGlobal", "Ptr", hData, "Int", True, "PtrP", pStream)
	hGdip:=DllCall("Kernel32.dll\LoadLibrary", "Str", "Gdiplus.dll", "UPtr")
	VarSetCapacity(SI, 16, 0), NumPut(1, SI, 0, "UChar")
	DllCall("Gdiplus.dll\GdiplusStartup", "PtrP", pToken, "Ptr", &SI, "Ptr", 0)
	DllCall("Gdiplus.dll\GdipCreateBitmapFromStream",  "Ptr", pStream, "PtrP", pBitmap)
	DllCall("Gdiplus.dll\GdipCreateH" (From?"ICON":"BITMAP") "FromBitmap", "Ptr", pBitmap, "PtrP", hBitmap, "UInt", 0)
	DllCall("Gdiplus.dll\GdipDisposeImage", "Ptr", pBitmap)
	DllCall("Gdiplus.dll\GdiplusShutdown", "Ptr", pToken)
	DllCall("Kernel32.dll\FreeLibrary", "Ptr", hGdip)
	DllCall(NumGet(NumGet(pStream + 0, 0, "UPtr")+(A_PtrSize * 2), 0, "UPtr"), "Ptr", pStream)
	Return hBitmap
}
; ----------------------------------------------------------------------------------------------------------------------
Join(a,s:=""){
	for k, v in a
		o.=s v
	return, SubStr(o, StrLen(s)+1)
}
GetWinPos(r=0){
	WinGetPos, , , Width, Height, A
	Return, r?Height:Width
}
GetTextLine(Line,Control,Title){
	ControlGet, OutputVar, Line, %Line%, %Control%, %Title%
	return, OutputVar
}
WM_LBUTTONUP(wParam, lParam) {
	IfNotEqual,A_GuiControl,"Diclyric",return
	ret:=IME_CHECK("A") 
	IfEqual,ret,0,Send,{vk15sc1F2}
}
ReClip(){
	Loop, {
		Sleep, 50
		Send, ^c
		ClipWait, 1
	}Until !ErrorLevel
	Sleep 150
}
; ----------------------------------------------------------------------------------------------------------------------
IME_CHECK(WinTitle){
	WinGet,hWnd,ID,%WinTitle%
	Return Send_ImeControl(DllCall("imm32\ImmGetDefaultIMEWnd",Uint,hWnd,Uint),0x005,"")
}
Send_ImeControl(DefaultIMEWnd, wParam, lParam){
	DetectSave:=A_DetectHiddenWindows       
	DetectHiddenWindows,ON                          
	SendMessage 0x283, wParam,lParam,,ahk_id %DefaultIMEWnd%
	If DetectSave<>A_DetectHiddenWindows
		DetectHiddenWindows,%DetectSave%
	return ErrorLevel
}
; ----------------------------------------------------------------------------------------------------------------------
AddPicture(p,s=0,t=0){
	if s
		y:=p.Presentations(2),x:=p.Presentations(2).Slides(s),SlideNumber:=s
	else
		y:=p.Presentations(1),x:=p.ActiveWindow.View.Slide,SlideNumber:=x.SlideIndex+1
	for Shape in x.Shapes
		If(Shape.Type=13){
			Shapes:=1,Height:=Shape.Height
			if(t<3){
				Shape.Delete
				if x.Shapes.Count {
					Shapes:=2
					x.Shapes.Range.Cut
				}
			}
			break
		}
	if(t>2&&Shapes){
		y.Slides(SlideNumber).Duplicate
		y.Windows(1).View.GotoSlide(SlideNumber) ; Next Page
		x:=p.ActiveWindow.View.Slide
	}
	x.Shapes.AddPicture("C:\Users\Public\1.png",False,True,0,0,720,Height?Height:405)
	if Shapes=2
		x.Shapes.Paste
	if(t<3&&Shapes)
		y.Windows(1).View.GotoSlide(SlideNumber) ; Next Page
	return, SlideNumber-1
}
; ----------------------------------------------------------------------------------------------------------------------
Ruler(Ny,clef,FHD){
	if(!WinActive("NoteWorthy Composer")||GetKeyState("LButton"))
		return
	static p_xpos
	SendMessage, 0x115, 2, 0, TNWC2ScoreEdit1, NoteWorthy Composer
	sleep, 50
	PixelSearch, , , 10, Ny-1, 500, Ny-1, 0xFFFFFF, , Fast
	ypos:=ErrorLevel
	ImageSearch, xpos, , 10, Ny, 500, Ny+35, *200 HBITMAP:*%clef%
	if(ErrorLevel||GetKeyState("ScrollLock", "T")){
		ImageSearch, xpos, , (FHD?1100:A_ScreenWidth-510), Ny, (FHD?1600:A_ScreenWidth), Ny+35, *200 HBITMAP:*%clef%
		if ErrorLevel {
			PixelSearch, xpos, , (FHD?1100:A_ScreenWidth-510), Ny, (FHD?1590:A_ScreenWidth-20), Ny, (ypos?0xF0F0F0:0xFFFFFF), , Fast
			IfNotEqual, ErrorLevel, 0, return
			xpos-=(ypos?1065:1066)
		}
	}
	if FHD
		xpos+=ypos?(xpos>999?-772:306):(xpos>999?-770:307)
	else xpos-=ypos?(xpos>999?1100:23):(xpos>999?1098:21)
	if(A_OSVersion="WIN_XP")
		xpos+=xpos>999?3:4
	if(xpos=p_xpos&&WinExist("Ruler"))
		return
	Gui, 1: Destroy
	Gui, 1: New
	Gui, 1: -Caption +Lastfound +AlwaysOnTop +Toolwindow
	Gui, 1: Color, FF0000
	WinSet, Region, 0-0 1078-0 1078-314 0-314 0-0   1-1 1079-1 1079-315 1-315 1-1
	WinGetPos, , yPos, , , NoteWorthy Composer
	Gui, 1: Show, % "w1079 h315 x" xpos " y" (FHD?605:Ny-96), Ruler
	p_xpos:=xpos
	WinActivate, NoteWorthy Composer
}
Signature(Key1,Key2){
	if (!Key1&&!Key2)
		return, ""
	Key:=Key1?SubStr("F#,C#,G#,D#,A#,E#,B#",1,Key1*3-1):SubStr("Bb,Eb,Ab,Db,Gb,Cb,Fb",1,Key2*3-1)
	return, "|Key|Signature:" Key "|Tonic:C`n"
}
TimeSig(Sig){
	Clipboard:="!NoteWorthyComposerClip(2.751,Single)`n|Bar`n|TimeSig|Signature:" Sig "`n!NoteWorthyComposerClip-End"
	Send, ^v{End}
}
SpaceS(y){
	ReClip()
	x:=StrSplit(Clipboard, "`r`n")
	for k, v in x {
		If(y<4&&RegExMatch(v, "Spacer\|Width:(\d+)", t)&&!InStr(x[k+1], "Never")){
			t1+=y=2?-5:(y=3?5:(InStr(x[k+1], "Bar")||InStr(x[k-1], "Bar")?5*y:10*y))
			v:="|Spacer|Width:" t1
		}else if(y=4&&RegExMatch(v, "Spacer\|Width:(\d+)", t)){
			If(RegExMatch(t1, "250|300|370|420")&&!InStr(x[k+1], "Bar"))
				t1-=30
			else If(InStr(x[k+1], "Bar")&&RegExMatch(t1, "140|190|65|115|200|250|125|175")||InStr(x[k-1], "Bar")&&RegExMatch(t1, "100|40|160"))
				t1-=15
			else if !InStr(x[k+1], "Never")
				t1-=(InStr(x[k+1], "Bar")||InStr(x[k-1], "Bar"))?5:10
			v:="|Spacer|Width:" t1
		}
		Temp.=v "`r`n"
	}
	Clipboard:=Temp
	Send, ^v
}
ScoreInset(s){
	t:=Clipboard
	Clipboard:=s
	Send, ^v{Right}
	Clipboard:=t
}
ScoreScroll(x){
	ControlGetFocus, control, A
	Loop, 3
		SendMessage, 0x114, % x, 0, %control%, A
}
ScoreMove(color,Nx1,Nx2,Ny){
	ControlGetFocus, control, A
	Loop, 9 {
		PixelSearch, , , Nx2-500, Ny, Nx2, Ny, %color%, , Fast
		IfEqual, ErrorLevel, 0, break
		else SendMessage, 0x114, 2, 0, %control%, A
	}
	Loop, 9 {
		PixelSearch, , , Nx1, Ny, Nx2, Ny, %color%, , Fast
		IfEqual, ErrorLevel, 0, break
		else SendMessage, 0x114, 0, 0, %control%, A
	}
	if(color=0x000000){
		PixelSearch, , , Nx2-1, Ny, Nx2, Ny, %color%, , Fast
		IfEqual, ErrorLevel, 0, SendMessage, 0x114, 1, 0, %control%, A
	}else{
		PixelSearch, , , Nx1, Ny, Nx2, Ny, %color%, , Fast
		IfNotEqual, ErrorLevel, 0, SendMessage, 0x114, 1, 0, %control%, A
	}
}
lyricPaste(Lyric){ ; 가사 붙여넣기
	Sleep, 50
	Send, ^l
	WinWaitActive, 보표 가사, , 2
	ControlSetText, Edit5, %Lyric%, 보표 가사
	While WinActive("보표 가사")
		ControlClick, 확인, 보표 가사 ; 확인
	Sleep, 50
}
DelChord(d=0){
	ReClip()
	x:=StrSplit(Clipboard, "`r`n"),Clipboard=""
	for k, v in x {
		if(d&&instr(v,"Note")&&instr(v,"Stem=Down"))
			continue
		if instr(v, "Chord"){
			if instr(v, "ArticulationsOnStem"){
				t:=RegExMatch(v, "\|Chord\|Dur:(.+?)\|Pos:(-?\d+)(\^?)(\|O.+),ArticulationsOnStem\|Dur2:(.+)\|Pos2:(.+)", t)
				v:="|Note|Dur:" (t2>t6?t1:t5) "|Pos:" (t2>t6?t2:t6) t3 StrReplace(t4, "Stem=Down", "")
			}else{
				t:=RegExMatch(v, "\|Chord\|Dur:(.+?)\|Pos:([^|]+)(\|O.+)?", t)
				Loop, parse, t2, `,
					t4:=A_LoopField
				v:="|Note|Dur:" t1 "|Pos:" t4 t3
			}
		}
		Clipboard.=v "`r`n"
	}
	Send, ^v
}
DelLine(Str, Words){
	x:=StrSplit(Str, "`r`n")
	for k, v in x
		if !RegExMatch(v,Words)
			r.=v "`r`n"
	return, r
}
GetVersion(){
	Send, !ha
	WinWaitActive, 정보, ,2
	WinGetText, t
	t:=RegExMatch(t,"i)Version ([^\s]+)", t)
	ControlSend,,{Enter}, 정보
	return, t1>2.75?1:0
}
GetNy(line,FHD){
	WinMoveNWC(FHD)
	ImageSearch, , Ny, 10, 200, 900, 670, *150 HBITMAP:*%line%
	if ErrorLevel {
		SendInput, 0{Home}{Right 2}^{Up 3}
		Sleep, 200
		ImageSearch, , Ny, 10, 200, 900, 670, *150 HBITMAP:*%line%
		if ErrorLevel {
			msgbox, 5선의 위치를 찾지 못했습니다.`n다음 사항들을 확인해 주세요.`n`n1. 블로그에 있는 NWC 양식파일을 사용하였는지`n2. NWC악보의 확대나 축소를 하였는지`n3. 5선이 검정색이고 주변이 흰색인지 확인
			return
		}else Ny+=111
	}else Ny+=111
	return, Ny
}
WinMoveNWC(FHD){
	WinActivate, NoteWorthy Composer
	if FHD {
		WinRestore, NoteWorthy Composer
		WinMove, NoteWorthy Composer, , 320, 340, 1617, 697
	}else WinMaximize, NoteWorthy Composer
	sleep, 100
}
LyricWidth(NwcVer, NwcFont){
	ControlGetText, Diclyric, Edit10, PPT악보 도우미
	ControlGetText, NwcScore, Edit6, PPT악보 도우미
	Note_all:=DelLine(NwcScore, "Text:|Width|PerformanceStyle|Tempo:|Flow|Ending|Dynamic")
	Note_all:=StrReplace(Note_all, "Chord|", "Note|Chord|")
	Note_all:=RegExReplace(Note_all, "Lyric=(Always|Never),?", "")
	Note_all:=RegExReplace(Note_all, "\|Bar\r?\n\|TempoVariance\|Style:Breath Mark\|Pause:0\|Pos:17", "|TempoVariance|Style:Breath Mark|Pause:0|Pos:17`r`n|Bar")
	Loop, parse, Note_all, `n, `r
	{
		if((InStr(A_LoopField,"Clef")||InStr(A_LoopField,"Signature")&&!InStr(n1,"Clef")&&!InStr(n1,"Signature"))&&!InStr(n1,"|Bar"))
			l.="|Bar`n"
		n1:=A_LoopField,l.=A_LoopField "`n"
	}
	Note_all:=StrSplit(l, "`n")
	for k, v in Note_all { ; 쉼표, User 표 합치기
		ifLess, k, 4, continue
		if InStr(v,"Fermata")
			Note_all[k]:="|TempoVariance|Style:Fermata|Pause:2|Pos:6.5|Justify:Center|Placement:AtNextNote"
		if RegExMatch(v,"TempoVariance|User|Marker"){
			Note_all[k]:=Note_all[k] "`n" Note_all[k+1]
			Note_all.Remove(k+1)
		}
		if(InStr(v,"Triplet|")&&!InStr(Note_all[k-1],"Marker")&&RegExMatch(v,"Pos:(-?\d).+?Stem=(\w+)",m)){
			m:=m2="Up"&&m1>-3?-5:(m2="Down"&&m1<3?5:"")
			m&&!InStr(Note_all[k-2],"Breath")?Note_all[k-1]:="|Marker|Pos:" m "|Target:Triplet`n" Note_all[k-1]
		}
	}
	Eng:=0,ly:=1,lb:=1,y:=RegExReplace(Diclyric,"\d+\.|\*"),l:=StrReplace(RegExReplace(y," ?`r?`n","#"),"0","9"),l:=StrSplit(l,""),w:="|Spacer|Width:"
	y:=StrReplace(StrReplace(RegExReplace(y,"`r?`n"," "),"~","~ "), "-", " - "),y:=RegExReplace(y,"([가-힣9](?(?=[!?])[!?]|)) ?","$1 "),y:=StrSplit(y," ")
	for k, v in l { ; 가사의 느낌표, 물음표 합치기
		if RegExMatch(l[k+1],"[!?]"){
			l[k]:=l[k] l[k+1]
			l.Remove(k+1)
		}
	}
	for k, v in Note_all { ; 하이픈 자동으로 넣기
		if(!l[ly]||!InStr(v,"Note|"))
			continue
		lb++
		if(l[ly]="-"){
			ly++
			continue
		}else if RegExMatch(l[ly],"[가-힣9]")
			Eng:=0
		else if RegExMatch(l[ly],"i)[A-Z']")
			Eng:=1
		While RegExMatch(l[ly+1],"i)[A-Z']")
			ly++
		if(l[ly+1]="-")
			ly++
		if RegExMatch(v,"\^|Slur"){
			if RegExMatch(l[ly+1],"[!?]")
				l[ly+1].="-"
			else l[ly].="-"
			if(Eng&&l[ly]="--")
				l[ly]:="-"
			else y.Insert(lb,"-")
			ly--
		}
		ly++
		While RegExMatch(l[ly],"[ #~]")
			ly++
	}
	l:=Join(l),Nwclyric:=StrReplace(Trim(l),"-"," - "),Nwclyric:=RegExReplace(Nwclyric,"([가-힣9](?(?=[!?])[!?]|)) ?","$1 "),Nwclyric:=RegExReplace(Nwclyric,"\s+(?=\s)"," "),Nwclyric:=RegExReplace(Nwclyric," ?#","`n"),Nwclyric:=StrReplace(Nwclyric,"~","-")
	ControlSetText, Edit5, % StrReplace(Nwclyric,"9","○"), PPT악보 도우미
	l:=StrReplace(l,"#"," "),l:=RegExReplace(l," [가-힣9]","힣"),l:=StrReplace(l,"~"," "),l:=RegExReplace(l,"i)([A-Z'])[A-Z']*","$1"),l:=RegExReplace(l,"\s+",""),ly:=1,Eng:=0,ly_all:=StrSplit(l,"")
	for k, v in ly_all { ; 가사의 느낌표, 물음표 합치기
		if RegExMatch(ly_all[k+1],"[!?]"){
			ly_all[k]:=ly_all[k] ly_all[k+1]
			ly_all.Remove(k+1)
		}
	}
	for k, v in Note_all { ; Width 넣기
		ifLess, k, 4, continue
		n1:=Note_all[k-1],n2:=Note_all[k-2],m0:=InStr(v,"Breath"),m1:=InStr(n1,"Breath"),b0:=InStr(v,"|Bar"),b1:=InStr(n1,"|Bar"),r0:=InStr(v,"Rest"),r1:=InStr(n1,"|Rest"),r2:=InStr(n2,"|Rest"),t0:=InStr(v,"Note|"),t1:=InStr(n1,"Note|")
		Eng:=ly_all[ly]="-"?Eng:(RegExMatch(ly_all[ly],"i)[A-Z']")?1:0)
		if(t0&&!InStr(v,"Always"))
			Note_all[k]:=InStr(v,"Opts")?StrReplace(v,"Opts:","Opts:Lyric=Always,"):v "|Opts:Lyric=Always"
		else if(b0&&InStr(Note_all[k+1],"Signature"))
			Note_all[k]:=StrReplace(v,"|Bar","|Bar|Style:Double")
		if(t1&&!m0&&RegExMatch(v,"Bar|Rest"))
			continue
		if(b1&&r0){
			Note_all[k]:=w "100`n" Note_all[k]
			IfEqual,m1,0,continue
		}
		if(!t0&&b1&&r2||m0&&r1&&InStr(Note_all[k+1],"|Rest"))
			continue
		if(t1&&InStr(v,"NoteWorthy")){
			Note_all[k]:=w (InStr(n1,"Dotted")?125:160) "`n" Note_all[k]
			continue
		}
		if InStr(v,"Clef"){
			If !Eng{
				t2:=InStr(n2,"Note|"),d2:=InStr(n2,"Dotted")
				if(t2&&InStr(n1,"SectionClose"))
					Note_all[k-1]:=w (d2?125:160) "`n" n1
				else if(b1&&t2&&!InStr(n2,"Never"))
					Note_all[k-1]:=w (d2?150:200-(ly_all[ly-1]="-"?50:0)) "`n" n1
			}
			continue
		}
		if InStr(y[ly-1],"~"){
			ly++
			continue
		}
		if(Eng&&!(ly_all[ly]="-"&&ly_all[ly-1]="-")){ ; 영어가사 간격
			y0:=NwcFont?NwcFont:47, y1:=GetTextSize(y[ly-1], "s" y0 " bold",  "HY헤드라인M"), y2:=GetTextSize(StrReplace(y[ly],"~",""), "s" y0 " bold",  "HY헤드라인M")
			w0:=((y1/2+y2/2)*5+30),sf:=RegExMatch(v,"[:,][xnb#]"),sv:=NwcVer&&RegExMatch(v,"[:,][nb]"),hp:=ly_all[ly]="-"||ly_all[ly-1]="-"
			if(b1&&!m1){
				w0:=w0//2-(hp?70:0),d1:=InStr(n2,"Dotted")?25:0,dd:=InStr(n2,"DblDotted")
				w1:=w0-d1-(dd?30:0)-(sf?55:0)+(sv?10:0)
				w2:=w0-d1-(dd?25:0)-(sf?50:0)+(sv?10:0)
				Note_all[k-1]:=w w1 "`n" Note_all[k-1] "`n" w w2 "`n"
			}else if(t1&&!m0||t0&&m1){
				d1:=InStr(n1,"Dotted")?50:0,dd:=InStr(n1,"DblDotted")?55:0
				Note_all[k]:=w w0-(hp?130:0)-d1-dd-(sf?105:0)+(sv?20:0)+(m1&&b1?50:0) "`n" Note_all[k]
			}else if(InStr(n1,"TimeSig|")&&InStr(n2,"|Bar")&&!InStr(n2,"Breath"))
				Note_all[k]:=w "50`n" Note_all[k]
			else if(m0&&r1&&!b0)
				Note_all[k]:=StrReplace(Note_all[k],"|TempoVariance|Style:Breath Mark|Pause:0|Pos:17", w "201`n|TempoVariance|Style:Breath Mark|Pause:0|Pos:17`n" w w0//2-70)
			if(ly_all[ly+1]="-"){
				ly++
				continue
			}
			if RegExMatch(v,"\^|Slur")
				ly--
		}else if !RegExMatch(ly_all[ly-1],"i)[A-Z']"){ ; 한글가사 간격
			if(ly_all[ly]="-")
				staff(ly_all[ly-1],ly_all[ly-1]="-"?0:1,k,NwcVer,Note_all)
			else if InStr(ly_all[ly],"힣")
				staff(ly_all[ly],ly_all[ly-1]="-"?2:3,k,NwcVer,Note_all)
			else staff(ly_all[ly],ly_all[ly-1]="-"?4:5,k,NwcVer,Note_all)
		}
		if(t0&&!InStr(v,"Never"))
			ly++
	}
	NwcScore:=StrReplace(Join(Note_all,"`n"),"Note|Chord","Chord")
	ControlSetText, Edit6, %NwcScore%, PPT악보 도우미
	return, NwcScore
}
GetTextSize(pStr, pSize=8, pFont="", pHeight=false) {
	Gui 9:Font, %pSize%, %pFont%
	Gui 9:Add, Text, R1, %pStr%
	GuiControlGet T, 9:Pos, Static1
	Gui 9:Destroy
	Return pHeight?TW "," TH:TW
}
staff(l,d,i,v,ByRef Note_all){ ; 한글가사 Width
	s:=[[30,10,45,20,30,80]							; --
		,[50,30,100,30,85,140]      					; 주-
		,[85,90,110,110,185,230]   					; - 힣
		,[140,100,190,100,250,300,65,40,115,40]	; 주 힣, Never
		,[65,5,105,15,80,140]       					; -주
		,[85,45,135,45,140,190,10,5,35,10]			; 주주
		,[0,0,70,40,0,0,0,0,60,70,0,0]]				; Breath
	p:=[50,50,40,40,40,40,100,100,85,85,85,85] ; 느낌표, 물음표
	w:="|Spacer|Width:",n0:=Note_all[i],n1:=Note_all[i-1],n2:=Note_all[i-2],sf:=RegExMatch(n0,"[:,][xnb#]"),sfb:=v&&RegExMatch(n0,"[:,][nb]")?20:0
	if InStr(n1,"|Bar"){
		m1:=InStr(n1,"Breath"),r0:=InStr(n0,"Rest"),r2:=InStr(n2,"Rest")
		if(r2&&(r0||!m1&&InStr(n0,"Note|"))||!m1&&InStr(n0,"Signature"))
			return
		w1:=sf&&!m1?(sfb-60):0,w2:=sf?-(m1?105:45)+sfb:0,d2:=InStr(n2,"Dotted"),bar:=(InStr(n2,"Note|")&&(InStr(n2,"Beam")||!RegExMatch(n2,"-|=Up")||!RegExMatch(n2,"Dur:[1368]")))?(d2?5:30):0
		if InStr(n0,"Never"){
			w1+=(d=3?95:50)-(d=3?bar:(d&&bar?15:(bar?0:-45)))
			w2+=15+(d=3?bar:(d&&bar?15:0))
		}else if InStr(n2,"Never"){
			if(d=3||d=5){
				sf:=RegExMatch(n2,"[:,][xnb#]"),sfb:=v&&RegExMatch(n2,"[:,][nb]")?20:0
				w1+=s[d+1][(d2?7:9)]-(sf?55:0)+sfb-(d=3?bar:(d&&bar?10:0))
				w2+=s[d+1][(d2?8:10)]-(sf?50:0)+sfb+(d=3?bar:(d&&bar?10:0))
			}
		}else{
			r1:=InStr(n1,"Rest")
			if(m1&&r2){
				w1:=0
				w2:=201-(sf?105:0)+sfb
			}else if(m1&&r0){
				w1:=((d=3||d=5?201:150)-(d2?50:0))
				w2:=0
			}else{
				m:=(d=2&&sf?(50-sfb):0)-(d>3&&bar&&!RegExMatch(n0,"-|=Up")?15:0),sw:=InStr(n2,"Whole")
				w1+=s[d+1][(d2?1:3)]-(d?(bar?(m1?30:bar):5):(bar?5:-45))-(sw?15:0)+m+(m1&&!r1?s[7][d+1]:0)-(d2&&m1?20:0)-(InStr(n2,"DblDotted")?50:0)
				w2:=m1&&(sf||InStr(n0,"Signature"))?0:w2+s[d+1][(d2?2:4)]+(d?(bar?(m1?30:bar):5):(bar?10:0))-(sw?10:0)-m+(m1&&!r1?s[7][d+7]:0)+(d2&&m1?20:0)
			}
		}
		if InStr(l,"!"){
			w1+=p[d]//2
			w2+=p[d]//2
		}else if InStr(l,"?"){
			w1+=p[d+6]//2
			w2+=p[d+6]//2
		}
		Note_all[i-1]:=(w1?w (w1<15?15:w1) "`n":"") n1 "`n" (w2?w (w2<15?15:w2):"")
	}else if(!InStr(n0,"|Bar")&&InStr(n1,"Note|")){
		m0:=InStr(n0,"Breath"),w1:=sf&&!m0?-105+sfb:0,d1:=InStr(n1,"Dotted"),dd:=InStr(n1,"DblDotted")&&!m0?50:0
		if(InStr(n0,"Never"))
			w1+=(d1?15:35)-dd
		else if(InStr(n1,"Never"))
			w1+=(d=3?165:55)-(InStr(n2,"Dotted")?30:0)-(RegExMatch(n1,"[:,][xnb#]")?(v&&RegExMatch(n1,"[:,][nb]")?85:105):0)-(InStr(n2,"|Bar")?85:0)-dd
		else if(!InStr(n0,"Note|")&&InStr(Note_all[i+1],"Never"))
			w1+=(d1?15:35)-dd
		else w1+=s[d+1][(d1?5:6)]+(d!=3&&d!=5&&m0&&!(InStr(n1,"Beam")||!RegExMatch(n1,"-|=Up")||!RegExMatch(n1,"Dur:[1368]"))?70:0)-dd ; -.-  --
		if InStr(l,"!")
			w1+=p[d]
		else if InStr(l,"?")
			w1+=p[d+6]
		Note_all[i]:=w (w1<15?15:w1) "`n" n0
	}else if(InStr(n1,"TimeSig|")&&InStr(n2,"|Bar")&&!InStr(n2,"Breath"))
		Note_all[i]:=w "50`n" n0
	else if(InStr(n0,"Breath")&&!InStr(n0,"|Bar")&&InStr(n1,"Rest"))
		Note_all[i]:=w "201`n" n0
}
; ----------------------------------------------------------------------------------------------------------------------
#IfWinActive, PPT악보 도우미
Initlyric: ; 초기화
	Reload
return
NwcFile: ; NWC 파일이름 (제목)
	Gui, 3: Submit, NoHide
	ifequal, Diclyric, , return
	if !NwcTitle {
		NwcTitle:=RegExReplace(GetTextLine(1,"Edit10","A"),"\s+(?=\s)")
		ControlSetText, Edit1, %NwcTitle%, A
	}
	NwcTitle:=Trim(NwcTitle),NwcFile:=SubStr(RegExReplace(Trim(GetTextLine(1,"Edit10","A") " " GetTextLine(2,"Edit10","A")),"\s+(?=\s)"),1,40)
	if !InStr(NwcFile,NwcTitle)
		NwcFile:=SubStr(NwcFile,1,35-StrLen(NwcTitle)) " (" NwcTitle ")"
	ControlSetText, Edit4, %NwcFile%, A
return
PsTitle: ; 제목넣기
	Gui, 3: Submit, NoHide
	ifequal, NwcTitle, , return
	NwcTitle:=Trim(NwcTitle)
	for StrPos in PsApp.activeDocument.layers {
		if(StrPos.Kind=2){
			StrPos.TextItem.Contents:=NwcTitle
			break
		}
	}
return
LyricAp: ; NWC 가사
	Gui, 1: Destroy
	Gui, 3: Submit, NoHide
	if !Nwclyric
		Nwclyric:=RegExReplace(StrReplace(RegExReplace(Diclyric,"\d+\.|\*"),"~","-"), "([가-힣0](?(?=[!?])[!?]|)) ?", "$1 ")
	WinActivate, NoteWorthy Composer
	WinWaitActive, NoteWorthy Composer, , 2
	lyricPaste(Nwclyric)
return
; ----------------------------------------------------------------------------------------------------------------------
#IfWinActive, NoteWorthy Composer
!^Numpad2::
	SoundBeep
	TimeSig("2/4")
return
!^Numpad3::
	SoundBeep
	TimeSig("3/4")
return
!^Numpad4::
	SoundBeep
	TimeSig("4/4")
return
!^Numpad6::
	SoundBeep
	TimeSig("6/8")
return
Numpad0::
	SoundBeep
	Send, {Space}
return
^Numpad1::
	SoundBeep
	Send, 0^{Down}{Down}
return
^Numpad2::
	SoundBeep
	Send, 0^{Down}{Up}
return
^Numpad3::
	SoundBeep
	Send, 0{Down 4}
return
^Numpad4::
	SoundBeep
	Send, 0{Down 2}
return
^Numpad5::
	SoundBeep
	Send, 0
return
^Numpad6::
	SoundBeep
	Send, 0{Up 2}
return
^Numpad7::
	SoundBeep
	Send, 0{Up 4}
return
^Numpad9::
	ScoreInset("|TempoVariance|Style:Fermata|Pause:0|Pos:9|Justify:Center|Placement:AtNextNote")
return
^NumpadAdd::
	SoundBeep
	Send, +{Left 3}^t{Right 4}
return
^NumpadDot::
	Send, {Backspace}
return
^Numpad0::
	SoundBeep
	Send, {Tab}
return
^7::
	ScoreInset("|Spacer|Width:10")
return
^8::
	ScoreInset("|Spacer|Width:251")
return
^9::
	ScoreInset("|Spacer|Width:201")
return
^0::
	ScoreInset("|Spacer|Width:151")
return
^w::
	Send, ^{F4}
return
^Up::
	SetTimer, RulerOn, 200
return
RulerOn:
	Ruler(Ny,clef,FHD)
return
^Down::
	SetTimer, RulerOn, Off
	Gui, 1: Destroy
return
!Up::
	ScoreInset("|Marker|Pos:5|Target:Triplet")
return
!Down::
	ScoreInset("|Marker|Pos:-5|Target:Triplet")
return
!Home:: ; NWC악보 → NWC Tool → NWC악보 (가사포함)
WidthAp:
	SetTimer, RulerOn, Off
	Gui, 1: Destroy
	WinActivate, NoteWorthy Composer
	Sleep, 100
	Send, ^{Home}{Home}+{End}
	ReClip()
	ControlSetText, Edit6, %Clipboard%, PPT악보 도우미
	Clipboard:=LyricWidth(NwcVer, NwcFont)
	Send, ^v
	ControlGetText, Nwclyric, Edit5, PPT악보 도우미
	lyricPaste(Nwclyric)
	Gosub, NwcEnd
	WinActivate, PPT악보 도우미
	WinActivate, NoteWorthy Composer
	Send, 0{Down}
	SetTimer, RulerOn, 200
return
$WheelUp::
	ScoreScroll(0)
return
$WheelDown::
	ScoreScroll(1)
return
^WheelUp::
	ScoreScroll(2)
return
^WheelDown::
	ScoreScroll(3)
return
$End::
NwcEnd:
	WinMoveNWC(FHD)
	Ny:=Ny?Ny:GetNy(line,FHD)
	if !Ny
		return
	Send, {End}
	Sleep, 100
	PixelGetColor, StrPos, 35, Ny
	IfNotEqual, StrPos, 0x000000, return
	ScoreMove("0x000000",(FHD?1500:A_ScreenWidth-110),(FHD?1590:A_ScreenWidth-20),Ny)
return
$R::
	Send, !tab!tb
return
$U::
	Now_Note:=Clipboard
	Clipboard:="!NoteWorthyComposerClip(2.75,Single)`n|TempoVariance|Style:Breath Mark|Pause:0|Pos:17`n!NoteWorthyComposerClip-End"
	Send, ^v{Right}
	Clipboard:=Now_Note
return
~Up::
	SoundBeep
return
~Down::
	SoundBeep
return
!o::
NwcNew:
	Gui, 3: Submit, NoHide
	if !NwcFile {
		Msgbox, 저장할 파일이름을 입력해 주세요.
		return
	}
	if(NwcMajor1&&NwcMajor2){
		Msgbox, 조표는 한 곳만 입력해 주세요.
		return
	}
	NwcFile:=Trim(NwcFile)
	if FileExist(WorkFolder NwcFile ".NWC") {
		Msgbox, 바탕화면에 같은 파일이름이 있습니다.
		return
	}
	WinActivate, NoteWorthy Composer
	WinWaitActive, NoteWorthy Composer, , 2
	IfNotEqual, ErrorLevel, 0, return
	Send, ^o
	WinWaitActive, 열기, , 2
	IfNotEqual, ErrorLevel, 0, return
	Clipboard:=A_ScriptDir "\PPT_Frm.2.75.nwc"
	Send, ^v{Enter}
	WinWaitNotActive, 열기, , 2
	IfNotEqual, ErrorLevel, 0, return
	Clipboard:=WorkFolder NwcFile
	Send, !fa
	WinWaitActive, 다른 이름으로 저장, , 2
	IfNotEqual, ErrorLevel, 0, return
	Send, ^v{Enter}
	WinWaitNotActive, 다른 이름으로 저장, , 2
	IfNotEqual, ErrorLevel, 0, return
	NwcTitle:=Trim(NwcTitle)
	for StrPos in PsApp.activeDocument.layers
		if(StrPos.Kind=2){
			StrPos.TextItem.Contents:=NwcTitle
			break
		}
	Send, ^i
	WinWaitActive, 파일 정보, , 2
	ControlSetText, Edit1, % NwcTitle, 파일 정보 ; 포토샵 제목
	ControlSetText, Edit2, % Trim(NwcMusic), 파일 정보 ; 작곡
	ControlSetText, Edit3, % Trim(NwcWord), 파일 정보 ; 작사
	Send, {Enter}
	WinWaitNotActive, 파일 정보, ,2
	Clipboard:="!NoteWorthyComposerClip(2.75,Single)`n" Signature(Trim(NwcMajor1),Trim(NwcMajor2)) "|TimeSig|Signature:" Trim(NwcTempo?NwcTempo:"4/4") "`n!NoteWorthyComposerClip-End" ; 장조, 박자
	Send, {End}^v
	Sleep, 50
	lyricPaste(RegExReplace(StrReplace(RegExReplace(Diclyric,"\d+\.|\*"),"~","-"), "([가-힣0](?(?=[!?])[!?]|)) ?", "$1 "))
	if RegExMatch(Diclyric, "[롤뢸룔륄촐쵤톨튈홀흉]"){
		Send, !fg
		WinWaitActive, 페이지 설정, , 2
		IfNotEqual, ErrorLevel, 0, return
		BlockInput, On
		Click, 103, 45
		MouseMove, 360, 186
		Click, 2
		BlockInput, Off
		WinWaitActive, 글꼴, , 2
		IfNotEqual, ErrorLevel, 0, return
		Send, !s47{Enter}
		Sleep, 50
		BlockInput, On
		Click, 45, 45
		Click, 520, 65
		BlockInput, Off
	}
	Send, {End}^s
	If IME_CHECK("A")
		Send,{vk15sc1F2}
	MouseMove, 400, 400
return
NumpadAdd::
	SpaceS(1)
return
NumpadSub::
	SpaceS(-1)
return
NumpadMult::
	SpaceS(4)
return
!NumpadAdd::
	SpaceS(3)
return
!NumpadSub::
	SpaceS(2)
return
NumpadDiv:: ; 이음줄 → 붙임줄
	ReClip()
	Clipboard:=RegExReplace(Clipboard, ",Slur\|Pos:(-?\d+)", "|Pos:$1^")
	Send, ^v
return
^NumpadMult:: ; 코드 삭제
	DelChord()
return
^NumpadDiv:: ; 코드 삭제 (Stem=Down 삭제)
	DelChord(1)
return
F9::  ; 다 지우기
	InputBox, InputVar, 모두 지우기, 1. 텍스트    2. 빈칸    3. 쉼표    직접입력
	IfNotEqual, ErrorLevel, 0, return
	if InputVar between 1 and 3
		InputVar:=StrSplit("\|Text,\|Spacer,Breath Mark",",")[InputVar]
	ReClip()
	Clipboard:=DelLine(Clipboard, InputVar)
	Send, ^v
	Sleep, 100
return
F12::
InitNWC:
	if !WinExist("NoteWorthy Composer"){
		msgbox, 먼저 NWC 프로그램을 실행 후 매크로를 실행해 주세요.
		PptApp.Quit
		ExitApp
	}
	WinMoveNWC(FHD)
	Tooltip, 초기화
	ControlGetPos, , , xPos, , TNWC2StaffLabelsWin1, NoteWorthy Composer
	IfNotEqual,xPos,0,send, !vl
	Loop, 5{
		ControlGet, xPos, Visible, , TToolbar%A_Index%, NoteWorthy Composer
		if xPos{
			ControlGetText, Now_Note, TToolbar%A_Index%, NoteWorthy Composer
			ControlGetPos, , , , xPos, TToolbar%A_Index%, NoteWorthy Composer
			if(Now_Note="Piano"){
				send, !vt
				winwait, 도구 모음
				ControlSend,ListBox1,{Down 2}{Space}{Enter}
			}else If(xPos>99)
				msgbox, TToolbar%A_Index%`t%Now_Note%`n`n높은 음자리표를 찾지 못할 경우 블로그를 참고하여`nNWC 좌, 우측의 도구모음을 위쪽으로 이동해야 합니다.
		}
	}
	Sleep, 200
	LastWork:=0, Now_Note:=0, xPos:=True
	WinActivate, NoteWorthy Composer
	Sleep, 100
	Gui, 1: Destroy
	NwcVer:=NwcVer?NwcVer:GetVersion()
	Tooltip
return
PgUp::
	IfEqual, FHD, 0, return
	WinRestore, NoteWorthy Composer
	WinGetPos, , , InputVar, , A
	IfEqual, InputVar, 1287, WinMove, NoteWorthy Composer, , 320, 340, 1617, 697
	else WinMove, NoteWorthy Composer, , 650, 340, 1287, 697
return
PgDn::
	Ny:=Ny?Ny:GetNy(line,FHD)
	if !Ny
		return
	Send, 0{Home}
	WinMoveNWC(FHD)
	PixelGetColor, StrPos, 134, 245
	IfNotEqual, StrPos, 0xFFFFFF, Send, {F11}
	Sleep, 150
	PixelGetColor, StrPos, (A_OSVersion="WIN_XP"?29:33), Ny+25
	IfEqual, StrPos, 0x000000, Send, {Tab}{Del}
	PixelGetColor, StrPos, (A_OSVersion="WIN_XP"?21:25), Ny+25
	IfEqual, StrPos, 0xFFFFFF, Send, {Tab}
return
!1::
	Form:=1 ; 한글 PPT
	goto, ReadyCap
!4::
!End::
PPTMake:
	Form:=4 ; 한글 PPT
	goto, ReadyCap
ReadyCap:
	Ny:=Ny?Ny:GetNy(line,FHD)
	if !Ny
		return
	WinMoveNWC(FHD)
	FileDelete, %A_Temp%\_NWC*.PNG
	PixelGetColor, StrPos, 400, Ny
	IfNotEqual, StrPos, 0x000000, return
	SetTimer, RulerOn, Off
	Gui, 1: Destroy
	PixelGetColor, StrPos, 134, Ny-108
	IfNotEqual, StrPos, 0xFFFFFF, Send, {F11}
	LastWork:=0, Now_Note:=20, xPos:=True
	Sleep, 100
	if(Form>3){
		Send, 0{Home}^s{Right 3}^{Up 3}
		IfEqual, FHD, 1, SetTimer, WinMoveMsgBox, 50
		Loop {
			InputVar:=A_Temp "\_NWC" (100+A_Index) ".PNG"
			Sleep, 100
			Gosub, Capture
		}Until LastWork>2
		IfEqual, FHD, 1, SetTimer, WinMoveMsgBox, OFF
		IfEqual, LastWork, 9, return
		Send, 0{Home}
		Gosub, PNG2PPT
		WinActivate, ahk_class Photoshop
		WinActivate, PowerPoint
		ControlGetText, Diclyric, Edit10, PPT악보 도우미
		WinActivate, PPT악보 도우미
		if InStr(Diclyric,"*")
			Gosub, PPTLyric
	}else{
		Send, 0{Right 3}^{Up 3}
		Loop, 2 {
			InputVar:=A_Temp "\_NWC" (100+A_Index) ".PNG"
			Sleep, 100
			Gosub, Capture
		}Until LastWork>2
		IfEqual, LastWork, 9, return
		Gosub, PNG2PPT
		WinActivate, PowerPoint
	}
return
Capture:
	Temp:=Mod(Form,3)
	if xPos{
		ImageSearch, ypos, , Now_Note, Ny, (FHD?1600:A_ScreenWidth), Ny+35, *150 HBITMAP:*%clef%
		if ErrorLevel{
			If(LastWork<2){
				LastWork:=9
				msgbox, 높은 음자리표를 찾지 못했습니다.
			}else LastWork++
			return
		}else Now_Note:=ypos-13
		ImageSearch, ypos, , Now_Note, Ny-141, Now_Note+1200, Ny-120, *150 HBITMAP:*%mark%
		ypos:=ypos?ypos-20:Now_Note+900
		ImageSearch, StrPos, , ypos, Ny-34, ypos+30, Ny+35, HBITMAP:*%bar%
		if ErrorLevel{
			Loop, 20 {
				ypos+=2
				ImageSearch, , , ypos+2, Ny-111, ypos+3, Ny+240, HBITMAP:*%line%
			}Until ErrorLevel
			ypos:=(ypos-Now_Note>(Temp?1078:1197))?Now_Note+(Temp?1078:1197):ypos
		}else{
			ypos:=StrPos+2
			if(ypos-Now_Note>(Temp?1078:1197)){
				Msgbox, 현재 페이지에서 악보의 길이가 초과되었습니다.
				IfMsgBox, Yes
				{
					Gui, 1: Destroy
					Send, 0^{Up 3}
					Now_Note:=20
					Goto, Capture
				}else{
					LastWork:=9
					return
				}
			}
		}
	}else{
		ImageSearch, ypos, , Now_Note, Ny-34, Now_Note+30, Ny+35, HBITMAP:*%bar%
		if ErrorLevel{
			Loop, 20 {
				Now_Note-=2
				ImageSearch, , , Now_Note-3, Ny-111, Now_Note-2, Ny+240, HBITMAP:*%line%
			}Until ErrorLevel
		}else Now_Note:=ypos+1
		PixelSearch, ypos, , 700, Ny-109, (FHD?1590:A_ScreenWidth-20), Ny-109, 0xCF0F0F, , Fast
		if ErrorLevel{
			PixelSearch, ypos, , 1000, Ny, (FHD?1590:A_ScreenWidth-20), Ny, 0xFFFFFF, , Fast
			ypos:=ErrorLevel?1590:ypos-1
		}else ypos-=11
		Now_Note:=ypos-Now_Note>(Temp?1078:1197)?ypos-(Temp?1078:1197):Now_Note
	}
	CaptureToFile(Ny, Now_Note, ypos-Now_Note+1, 350, hung, InputVar) ; CaptureScreen =========
	Send, {F3}
	Sleep, 150
	If WinActive("찾기",,"NoteWorthy"){
		Sleep, 100
		SendInput, {Tab}{Enter}{Down 9}{Enter 2}
		Sleep, 150
	}
	If WinActive("Information",,"Iron"){
		LastWork+=1
		Send, {Enter}{End}
		Sleep, 100
	}
	if xPos{
		If LastWork
			ScoreMove("0x000000",(FHD?1500:A_ScreenWidth-110),(FHD?1590:A_ScreenWidth-20),Ny)
		else ScoreMove("0x000000",(FHD?1500:A_ScreenWidth-410),(FHD?1590:A_ScreenWidth-20),Ny)
		Loop, 2 {
			ImageSearch, StrPos, , A_Index=1?10:Now_Note+21, Ny-141, 1410, Ny-120, *150 HBITMAP:*%mark%
			Now_Note:=StrPos?StrPos-20:(A_Index=2?Now_Note:500)
		}
	}else if(LastWork<2){
		Send, +{F3}{Right}
		Sleep, 100
		Now_Note:=20
	}
	xPos:=!xPos
return
WinMoveMsgBox:
	if(ID:=WinExist("악보의 길이 확인"))
		WinMove, ahk_id %ID%, , A_ScreenWidth/2-58, 100 
return
; ----------------------------------------------------------------------------------------------------------------------
#IfWinActive PowerPoint
;	PptApp.Run(PptApp.ActivePresentation.Name "!Macroname")
Numpad7::
PPTLyric:
	ControlGetText, Diclyric, Edit10, PPT악보 도우미
	ifequal, Diclyric, , return
	Temp=
	Loop, parse, Diclyric, `n, `r
		if Instr(A_LoopField,".")
			Temp.="/" Trim(StrReplace(RegExReplace(A_LoopField,"([a-z])-([a-z])","$1$2"),"~",""))
	InputVar:=RegExReplace(Substr(Temp,2),"0[^.]","○")
	WinActivate, PowerPoint
	x:=PptApp.ActivePresentation,Color:=x.Slides.Count
	While x.Slides(Color).Shapes.Count=0 ; 빈 슬라이드 제거
		x.Slides(Color--).Delete
	if InStr(InputVar, "/"){
		InputLyric:=StrSplit(InputVar, "/")
		If(x.Slides(1).Shapes(1).Type!=1){
			x.Slides(1).Shapes(1).Cut
			x.Slides(1).Shapes.Paste
		}
		SCount:=x.Slides(1).Shapes.Count-1,InputVar:=InputLyric.MaxIndex()
		While InputVar<SCount
			if x.Slides(1).Shapes(SCount).Type=1
				x.Slides(1).Shapes(SCount--).Delete
		SCount:=x.Slides(1).Shapes.Count-1
		Loop, % SCount {
			InputVar:=SCount<4?4:SCount
			Color:=(680-(InputVar-1)*5)/InputVar
			InputVar:=x.Slides(1).Shapes(A_Index)
			InputVar.Left:=20+(Color+5)*(A_Index-1)
			InputVar.Width:=Color
			InputVar:=InputVar.TextFrame.TextRange
			InputVar.Text:=InputLyric[A_Index]
			StrPos:=InputVar.Paragraphs(1).Lines.Count
			While StrPos>1
				InputVar.Paragraphs(1).Lines(StrPos--).Delete
		}
	}else{
		StrPos:=x.Slides(1).Shapes.Count+1
		While --StrPos
			If x.Slides(1).Shapes(StrPos).Type=1
				x.Slides(1).Shapes(StrPos).Delete
	}
	x.Slides(1).Select
	WinActivate, PPT악보 도우미
return
Numpad8::
PPTHyper:
	x:=PptApp.ActivePresentation
	x.Slides(1).Select
	SCount:=x.Slides(1).Shapes.Count-1,InputLyric=""
	IfEqual, SCount, 0, return
	If(x.Slides(1).Shapes(1).Type!=1){
		x.Slides(1).Shapes(1).Cut
		x.Slides(1).Shapes.Paste
	}
	Loop, % SCount {
		Temp:=x.Slides(1).Shapes(A_Index).TextFrame.TextRange.Text
		Temp:=SubStr(Temp,1,SubStr(Temp,2,1)="."?1:2)
		InputLyric.=Temp "/"
		Temp:=x.Slides(Temp+0).SlideID . "," . Temp . ",슬라이드 " . Temp
		x.Slides(1).Shapes(A_Index).ActionSettings(1).Hyperlink.SubAddress:=Temp
	}
	InputLyric.=x.Slides.Count+1,InputLyric:=StrSplit(InputLyric, "/")
	for StrPos in x.Slides(1).Shapes
		if StrPos.Type=1
			StrPos.Select(0)
	PptApp.ActiveWindow.Selection.ShapeRange.Cut
	StrPos:=2,SCount:=x.Slides.Count
	Loop, % SCount {
		x.Slides(A_Index).Shapes.Paste
		If(A_Index=InputLyric[StrPos])
			StrPos++
		x.Slides(A_Index).Shapes(StrPos).TextFrame.TextRange.Font.Color.RGB:=255
	}
	x.Slides(SCount).Select
return
Numpad9:: ; making wide
PPTWide:
	x:=PptApp.ActivePresentation
	If(x.PageSetup.SlideSize=7||x.PageSetup.SlideSize=15)
		return
	WinGetTitle, InputVar, NoteWorthy Composer
	InputVar:=SubStr(InputVar, 24)?SubStr(InputVar, 24, -(InStr(InputVar,"*")?3:1)):"PPT"
	x.SaveAs(WorkFolder InputVar ".PPT", 1)
	if(PTVer>14&&x.Slides(1).Shapes.Count>1){
		InputLyric:=[]
		for StrPos in x.Slides(1).Shapes {
			if StrPos.Type=1 {
				InputLyric.Push(StrPos.Left)
				InputLyric.Push(StrPos.Width)
			}
		}
	}
	if(PTVer<14){ ; PPT 2007 이하
		x.PageSetup.SlideSize:=7 ; ppSlideSizeCustom
		x.PageSetup.SlideWidth:=720
		x.PageSetup.SlideHeight:=405
		x.PageSetup.FirstSlideNumber:=1
		x.PageSetup.SlideOrientation:=1
		x.PageSetup.NotesOrientation:=2
	}else x.PageSetup.SlideSize:=15
	for SCount in x.Slides {
		StrPos:=SCount.Shapes(SCount.Shapes(1).Type=1?SCount.Shapes.Count:1)
		StrPos.Height:=370,StrPos.LockAspectRatio:=0
		if PTVer>14
			StrPos.Left:=0, StrPos.Width:=720
	}
	if x.Slides(1).Shapes.Count=1
		return
	for SCount in x.Slides {
		LastWork:=0
		for StrPos in SCount.Shapes {
			if(StrPos.Type=1){
				StrPos.Height:=18, StrPos.Top:=StrPos.Top>380?380:357
				if(PTVer>14){
					StrPos.Left:=InputLyric[++LastWork]
					StrPos.Width:=InputLyric[++LastWork]
					StrPos.TextFrame.TextRange.Font.Size:=11
				}
			}
		}
	}
return
NumpadAdd::
PPTSave:
	x:=PptApp.ActivePresentation
	If(x.PageSetup.SlideSize!=7&&x.PageSetup.SlideSize!=15)
		return
	x.SaveAs(WorkFolder InputVar "_Wide.PPT", 1)
	x.Close
	FileDelete, C:\Users\Public\1.PNG
	WinActivate, NoteWorthy Composer
	WinWaitActive, NoteWorthy Composer, ,2
	ifnotequal, ErrorLevel, 0, return
	Send, 0{Home}^s^{F4}^{F4}
	Gui, 1: Destroy
	Loop, 10
		ControlSetText, Edit%A_Index%, , PPT악보 도우미
	WinActivate, PPT악보 도우미
return
NumpadSub::
	x:=PptApp.ActivePresentation
	for SCount in x.Slides {
		If SCount.SlideIndex=1
			continue
		StrPos:=SCount.Shapes.Count+1
		While --StrPos
			If SCount.Shapes(StrPos).Type=1
				SCount.Shapes(StrPos).Delete
	}
	for StrPos in x.Slides(1).Shapes
		If StrPos.Type=1
			StrPos.TextFrame.TextRange.Font.Color.RGB:=0
	x.Slides(1).Select
return
; ----------------------------------------------------------------------------------------------------------------------
#IfWinActive ahk_class Photoshop
F9::
	PsApp.doAction("PNG저장","PPT악보")
	Sleep, 100
	PNG2PPT(PptApp,2)
return
F12::
InitPS:
	PsApp:=ComObjActive("Photoshop.Application")
	if FHD
		WinMove, ahk_class Photoshop, , 240, 0, 1482, 1040
	else WinMaximize, ahk_class Photoshop
	WinActivate, ahk_class Photoshop
	if !PsApp.Documents.Count
		PsApp.Open(A_ScriptDir "\PPT_Frm_Wide.psd")
	PsApp.activeDocument:=PsApp.Documents[1]
	Sleep, 1000
	Send, ^0
	if(A_ScreenWidth>1439&&A_ScreenHeight>799)
		Send, ^1
return
PNG2PPT:
	WinActivate, PowerPoint
	if !PptApp.Presentations.Count
		PptApp.Presentations.Open(A_ScriptDir "\PPT_Frm.ppt")
	Loop, Files, % A_Temp "\_NWC*.PNG"
		SCount:=A_Index
	StrPos:=0
	Loop, % SCount {
		ToolTip, % "작업중: " A_Index//2 " / " SCount//2
		LastWork:=PsApp.Open(A_Temp "\_NWC" (100+A_Index) ".PNG")
		LastWork.Selection.SelectAll()
		LastWork.Selection.Copy()
		LastWork.Close(2)
		if !Mod(A_Index,2){
			PsApp.doAction("R1","PPT악보")
			PsApp.doAction("PNG저장","PPT악보")
			Sleep, 100
			if(SCount>2){
				StrPos++
				PptApp.ActivePresentation.Slides(StrPos+1).Duplicate
				PptApp.ActivePresentation.Slides(StrPos).Select
				PptApp.ActivePresentation.Slides(StrPos).Shapes.AddPicture("C:\Users\Public\1.png",False,True,0,0,720,405)
			}else PNG2PPT(PptApp,SCount)
		}else PsApp.doAction("L1","PPT악보")
		ToolTip
		If WinActive("Adobe Photoshop CS5 Extended")
			return
	}
return
PNG2PPT(PptApp,SCount){
	ypos:=AddPicture(PptApp,,SCount)
	if PptApp.Presentations.Count=2
		AddPicture(PptApp,ypos)
}